/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.GiftInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class BirthdayOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    Context context;
    public static final String TAG = "BirthdayOperation";
    public HttpConnect conn = null;
    private int type;
    private int pageIndex;

    public BirthdayOperation(Context context, HttpMsg httpMsg, int type, String url) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void sendData(HashMap<String, Object> map) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                if (key.equals("pageIndex")) {
                    this.pageIndex = (Integer)val;
                }
                obj.put(key, val);
            }
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    private void returnGiftList(String result, int bean, int diamond) {
        try {
            ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    GiftInfo giftInfo = new GiftInfo();
                    giftInfo.parsingBirthdayGift(jsonObject);
                    giftInfos.add(giftInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(giftInfos, null, null, this.type, bean, diamond);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnMyList(String result, int giftNum) {
        try {
            ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    GiftInfo giftInfo = new GiftInfo();
                    giftInfo.parsingBirthdayGiftMy(jsonObject);
                    giftInfos.add(giftInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(giftInfos, null, null, this.type, this.pageIndex, giftNum);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.getBoolean("state");
            if (state) {
                switch (this.type) {
                    case 5401: {
                        this.returnGiftList(ob.optString("result", ""), ob.optInt("bean", 0), ob.optInt("diamond", 0));
                        break;
                    }
                    case 5402: {
                        this.httpMsg.despatch(ob.optString("result", ""), null, null, this.type, 0, 0);
                        break;
                    }
                    case 5403: {
                        this.returnMyList(ob.optString("result", ""), ob.optInt("giftNum", 0));
                    }
                }
            } else {
                int result = ob.optInt("result");
                if (result == 601) {
                    this.httpMsg.handleErrorInfo(temp, result, this.type);
                } else {
                    this.userErrInfo(result, ob.optString("msg", ""));
                }
            }
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

