/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsgChat;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.GiftInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChatMasterMarryOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsgChat httpMsg;
    private int type;
    Context context;
    private int position;
    private String message_id;
    public static final String TAG = "ChatMasterMarryOperation";
    public HttpConnect conn = null;

    public ChatMasterMarryOperation(Context context, HttpMsgChat httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = "";
        if (type == 2203) {
            url = "http://mob.imlianai.com/call.do?cmd=mobileMarry.handler";
        } else if (type == 2105) {
            url = "http://mob.imlianai.com/call.do?cmd=mobileTeacher.handler";
        } else if (type == 2104) {
            url = "http://mob.imlianai.com/call.do?cmd=mobileTeacher.handler";
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void marryAction(String uid, String tid, int type, String loginKey) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("tid", (Object)tid);
            object.put("loginKey", (Object)loginKey);
            object.put("type", type);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void askOperation(String uid, String tid, String loginKey, int type) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("tid", (Object)tid);
            object.put("loginKey", (Object)loginKey);
            object.put("type", type);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void guessOperation(String uid, String opt, String id, String loginKey, String tid, int position, String message_id) {
        this.position = position;
        this.message_id = message_id;
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("tid", (Object)tid);
            object.put("loginKey", (Object)loginKey);
            object.put("id", (Object)id);
            object.put("opt", (Object)opt);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleChatErrorInfo(err, 0, this.type);
    }

    private void returnGiftList(JSONObject jsonObject) {
        try {
            String result = jsonObject.optString("result", "");
            ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    JSONObject object = jsonArray.getJSONObject(i);
                    GiftInfo giftInfo = new GiftInfo();
                    giftInfo.parsingGiftInfo(object);
                    giftInfos.add(giftInfo);
                    ++i;
                }
            }
            this.httpMsg.despatchChat(giftInfos, null, null, this.type, 0, 0);
        }
        catch (Exception e) {
            this.httpMsg.handleChatErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.optBoolean("state");
            if (state) {
                if (this.type == 2203) {
                    this.returnGiftList(ob);
                } else if (this.type == 2105) {
                    this.httpMsg.despatchChat(null, null, null, this.type, 0, 0);
                } else if (this.type == 2104) {
                    this.httpMsg.despatchChat(null, null, null, this.type, 0, 0);
                }
            } else {
                int result = ob.optInt("result");
                this.userErrInfo(result, ob.optString("msg", ""));
            }
        }
        catch (Exception e) {
            this.httpMsg.handleChatErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleChatErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleChatErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

