/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.AddContactMainInfo;
import com.cn.anddev.andengine.model.MailInformation;
import com.cn.anddev.andengine.model.UserInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContactsRequest
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private String TAG = "ContactsRequest";
    private HttpMsg mHttpMsg;
    private HttpConnect conn;
    private int type;
    private int pageIndex;

    public ContactsRequest(Context context, HttpMsg httpMsg, int type) {
        this.mHttpMsg = httpMsg;
        this.type = type;
        String url = "http://mob.imlianai.com/call.do?cmd=mobile.getContacts";
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestContastInfo(String uid, int pageIndex) {
        byte[] o = null;
        try {
            boolean flag;
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("type", this.type);
            this.pageIndex = pageIndex;
            boolean bl = flag = this.type == 6 || this.type > 0 && this.type < 4;
            if (flag) {
                object.put("pageIndex", pageIndex);
            }
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    public void requestContastInfo(String uid) {
        this.requestContastInfo(uid, 0);
    }

    public void requestHasPerson(String uid, String searchId) {
        byte[] o = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("type", this.type);
            object.put("suid", (Object)searchId);
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    private void requestConcer(String uid, String tid, boolean add, String loginKey) {
        byte[] o = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            if (add) {
                this.type = 4;
                object.put("type", 4);
            } else {
                this.type = 5;
                object.put("type", 5);
            }
            object.put("tid", (Object)tid);
            object.put("loginKey", (Object)loginKey);
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    public void requestAddConcer(String uid, String tid, String loginKey) {
        this.requestConcer(uid, tid, true, loginKey);
    }

    public void requestCancelConcer(String uid, String tid, String loginKey) {
        this.requestConcer(uid, tid, false, loginKey);
    }

    public void requestLianaiUser(String uid, List<String> phoneNum) {
        byte[] o = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            StringBuffer buffer = new StringBuffer();
            if (phoneNum != null && phoneNum.size() > 0) {
                buffer.append(phoneNum.get(0));
                int i = 1;
                while (i < phoneNum.size()) {
                    buffer.append(",");
                    buffer.append(phoneNum.get(i));
                    ++i;
                }
            }
            if (buffer.length() > 0) {
                object.put("phoneNumbers", (Object)buffer.toString());
            }
            object.put("type", this.type);
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    public void requestRecommendConcer(String uid, String loginKey) {
        byte[] o = null;
        try {
            JSONObject object = new JSONObject();
            this.type = 14;
            object.put("type", this.type);
            object.put("uid", (Object)uid);
            object.put("loginKey", (Object)loginKey);
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    public void requestAddRecommendConcer(String uid, String tid, String loginKey) {
        byte[] o = null;
        try {
            JSONObject object = new JSONObject();
            this.type = 15;
            object.put("type", this.type);
            object.put("uid", (Object)uid);
            object.put("tid", (Object)tid);
            object.put("loginKey", (Object)loginKey);
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    public void requestPersonInvite(String uid, int pageIndex) {
        byte[] o = null;
        try {
            JSONObject object = new JSONObject();
            this.type = 16;
            this.pageIndex = pageIndex;
            object.put("type", this.type);
            object.put("uid", (Object)uid);
            object.put("pageIndex", pageIndex);
            o = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception e) {
            Log.v((String)this.TAG, (String)"create coon fail!");
        }
        this.conn.setPostData(o);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        String temp = Tools.seekSep((InputStream)in);
        Log.v((String)this.TAG, (String)temp);
        try {
            JSONObject object = new JSONObject(temp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 0: {
                        this.mHttpMsg.despatch(object.optInt("friendSize"), object.optInt("concernSize"), object.optInt("followSize"), this.type, object.optInt("groupNum"), 0);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        UserInfo userInfo = new UserInfo();
                        this.mHttpMsg.despatch(userInfo.decodeContacts(object), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.mHttpMsg.despatch(object.optInt("result"), object.optInt("relation"), null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 9: {
                        this.mHttpMsg.despatch(true, null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 10: {
                        this.mHttpMsg.despatch(true, null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 11: {
                        AddContactMainInfo info = new AddContactMainInfo();
                        info.decode(object);
                        this.mHttpMsg.despatch(info, null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 13: {
                        MailInformation mailInformation = new MailInformation();
                        this.mHttpMsg.despatch(mailInformation.decode(object), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 14: {
                        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
                        UserInfo infoTmp = null;
                        JSONArray array = object.optJSONArray("result");
                        if (array == null) {
                            this.mHttpMsg.despatch(null, null, null, this.type, this.pageIndex, 0);
                            return;
                        }
                        int i = 0;
                        while (i < array.length()) {
                            JSONObject obj = array.optJSONObject(i);
                            infoTmp = new UserInfo();
                            infoTmp.setName(obj.optString("name"));
                            infoTmp.setHead(obj.optString("head"));
                            infoTmp.setUid(obj.optString("uid"));
                            userInfos.add(infoTmp);
                            ++i;
                        }
                        this.mHttpMsg.despatch(userInfos, null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 15: {
                        UserInfo userInfo = new UserInfo();
                        userInfo.parsingVisit(object.optJSONObject("result"));
                        this.mHttpMsg.despatch(userInfo, null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 16: {
                        UserInfo userInfo = new UserInfo();
                        this.mHttpMsg.despatch(userInfo.decodeInvitePerson(object), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                }
            } else {
                int result = object.optInt("result");
                String msg = object.optString("msg", "");
                this.mHttpMsg.handleErrorInfo(msg, result, this.type);
            }
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }
}

