/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.FaceInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class FaceOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    Context context;
    public static final String TAG = "FaceOperation";
    public HttpConnect conn = null;
    private int type;
    private int pageIndex;
    private int position;

    public FaceOperation(Context context, HttpMsg httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = null;
        switch (type) {
            case 2400: {
                url = "http://mob.imlianai.com/call.do?cmd=emoticon.list";
                break;
            }
            case 2401: {
                url = "http://mob.imlianai.com/call.do?cmd=emoticon.buyEmoticon";
                break;
            }
            case 2402: {
                url = "http://mob.imlianai.com/call.do?cmd=emoticon.detail";
                break;
            }
            case 2403: {
                url = "http://mob.imlianai.com/call.do?cmd=emoticon.buyRecord";
                break;
            }
            case 2404: {
                url = "http://mob.imlianai.com/call.do?cmd=emoticon.default";
                break;
            }
        }
        if (url == null) {
            url = "http://mob.imlianai.com/call.do?cmd=";
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void getMainList(String uid, int pageIndex, String loginKey) {
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("pageIndex", pageIndex);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getDefaultList(String uid, String loginKey) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void buyFace(String uid, int emoticonCode, String loginKey, int position, int costJewel) {
        this.position = position;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("emoticonCode", emoticonCode);
            o.put("loginKey", (Object)loginKey);
            if (costJewel > -1) {
                o.put("costJewel", costJewel);
            }
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void faceDetail(String uid, int emoticonCode, String loginKey) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("emoticonCode", emoticonCode);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getBuyRecord(String uid, int pageIndex, String loginKey) {
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("pageIndex", pageIndex);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    private void returnMainList(JSONObject jsonObject) {
        try {
            FaceInfo faceInfo = null;
            ArrayList<FaceInfo> faceInfos = new ArrayList<FaceInfo>();
            String list = jsonObject.optString("list", "");
            if (MyTool.stringValid(list)) {
                JSONArray jsonArray = new JSONArray(list);
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    JSONObject myjJsonObject = jsonArray.getJSONObject(i);
                    FaceInfo myFaceInfo = new FaceInfo();
                    myFaceInfo.paresingFacePackageInfo(myjJsonObject);
                    faceInfos.add(myFaceInfo);
                    ++i;
                }
            }
            if (this.pageIndex == 1) {
                faceInfo = new FaceInfo();
                faceInfo.setFrontCover(jsonObject.optString("coverPic", ""));
                faceInfo.setFacePackageId(jsonObject.optInt("emoticonCode", 0));
            }
            this.httpMsg.despatch(faceInfos, faceInfo, null, this.type, this.pageIndex, this.position);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void returnRecordList(JSONObject jsonObject) {
        try {
            ArrayList<FaceInfo> faceInfos = new ArrayList<FaceInfo>();
            String list = jsonObject.optString("list", "");
            if (MyTool.stringValid(list)) {
                JSONArray jsonArray = new JSONArray(list);
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    JSONObject myjJsonObject = jsonArray.getJSONObject(i);
                    FaceInfo myFaceInfo = new FaceInfo();
                    myFaceInfo.paresingBuyRecord(myjJsonObject);
                    faceInfos.add(myFaceInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(faceInfos, null, null, this.type, this.pageIndex, this.position);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void returnDefaultList(JSONObject jsonObject) {
        try {
            FaceInfo faceInfo;
            ArrayList<FaceInfo> faceInfos = new ArrayList<FaceInfo>();
            String bean0 = jsonObject.optString("bean0", "");
            String bean1 = jsonObject.optString("bean1", "");
            if (MyTool.stringValid(bean0)) {
                JSONObject jsonObject1 = jsonObject.getJSONObject("bean0");
                faceInfo = new FaceInfo();
                faceInfo.paresingDefaultInfo(jsonObject1);
                faceInfos.add(faceInfo);
            }
            if (MyTool.stringValid(bean1)) {
                JSONObject jsonObject2 = jsonObject.getJSONObject("bean1");
                faceInfo = new FaceInfo();
                faceInfo.paresingDefaultInfo(jsonObject2);
                faceInfos.add(faceInfo);
            }
            this.httpMsg.despatch(faceInfos, null, null, this.type, this.pageIndex, this.position);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void returnFaceDetail(JSONObject jsonObject) {
        try {
            ArrayList<FaceInfo> faceInfos = new ArrayList<FaceInfo>();
            FaceInfo myfaceInfo = new FaceInfo();
            myfaceInfo.paresingFaceDetail(jsonObject);
            String emoticonList = jsonObject.optString("emoticonList", "");
            if (MyTool.stringValid(emoticonList)) {
                JSONArray jsonArray = new JSONArray(emoticonList);
                int size = jsonArray.length();
                int i = 0;
                while (i < size) {
                    JSONObject myJsonObject = jsonArray.getJSONObject(i);
                    FaceInfo faceInfo = new FaceInfo();
                    faceInfo.setFaceName(myJsonObject.optString("iconName", ""));
                    faceInfo.setFaceImageUrl(myJsonObject.optString("largeIconUrl", ""));
                    faceInfo.setFaceImageUrlSmall(myJsonObject.optString("smallIconUrl", ""));
                    faceInfos.add(faceInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(myfaceInfo, faceInfos, null, this.type, this.pageIndex, this.position);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.getBoolean("state");
            if (state) {
                switch (this.type) {
                    case 2400: {
                        this.returnMainList(ob);
                        break;
                    }
                    case 2401: {
                        this.httpMsg.despatch(ob.optString("url", ""), null, null, this.type, this.pageIndex, this.position);
                        break;
                    }
                    case 2402: {
                        String bean = ob.optString("bean", "");
                        if (MyTool.stringValid(bean)) {
                            JSONObject jsonObject = new JSONObject(bean);
                            this.returnFaceDetail(jsonObject);
                            break;
                        }
                        this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
                        break;
                    }
                    case 2403: {
                        this.returnRecordList(ob);
                        break;
                    }
                    case 2404: {
                        this.returnDefaultList(ob);
                        break;
                    }
                    default: {
                        this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u9519\u8bef", 0, this.type);
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                if (result == 601) {
                    this.httpMsg.handleErrorInfo(temp, result, this.type);
                } else {
                    this.userErrInfo(result, ob.optString("msg", ""));
                }
            }
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

