/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.GameDetailInfo;
import com.cn.anddev.andengine.model.GameListInfo;
import com.cn.anddev.andengine.model.GameRecommendInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class GameOperation
extends BaseRequstClass
implements IHttpUrl,
IHttpListener {
    private int type;
    private HttpConnect conn;
    private HttpMsg mHttpMsg;
    private String TAG = this.getClass().getName();
    private int pageIndex;

    public GameOperation(Context context, HttpMsg httpMsg, String url) {
        this.mHttpMsg = httpMsg;
        Log.v((String)this.TAG, (String)url);
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestActions(int action, Map<String, Object> map, int pageIndex) {
        this.type = action;
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)this.TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        String tmp = Tools.seekSep((InputStream)in);
        try {
            JSONObject object = new JSONObject(tmp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 6084: {
                        int status = object.optInt("status", 0);
                        int maxGameCode = object.optInt("maxGameCode", 0);
                        this.mHttpMsg.despatch(status, null, null, this.type, status, maxGameCode);
                        break;
                    }
                    case 5200: {
                        this.decodeGameList(object);
                        break;
                    }
                    case 5201: {
                        this.mHttpMsg.despatch(this.decodeGameDetailInfo(object), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5205: {
                        this.mHttpMsg.despatch(this.decodeGameRecommendInfos(object), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5204: {
                        this.mHttpMsg.despatch(object.optBoolean("result", false), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5203: {
                        this.mHttpMsg.despatch(object.optBoolean("result", false), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5202: {
                        this.mHttpMsg.despatch(object.optInt("result", 0), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5206: 
                    case 5207: 
                    case 5208: {
                        this.mHttpMsg.despatch(object.optBoolean("result", false), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5209: {
                        this.mHttpMsg.despatch(object.optBoolean("result", false), object.optString("appid", ""), null, this.type, this.pageIndex, 0);
                    }
                }
            } else {
                int result = object.optInt("result");
                String msg = object.optString("msg");
                if (msg == null || msg.equals("")) {
                    this.mHttpMsg.handleErrorInfo("", result, this.type);
                } else {
                    this.errInfo(this.mHttpMsg, this.type, result, msg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errInfo(this.mHttpMsg, this.type, 0, "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
        }
    }

    private GameDetailInfo decodeGameDetailInfo(JSONObject object) {
        GameDetailInfo info = new GameDetailInfo();
        info.decodeGameDetail(object);
        return info;
    }

    private List<GameRecommendInfo> decodeGameRecommendInfos(JSONObject object) {
        ArrayList<GameRecommendInfo> infos = new ArrayList<GameRecommendInfo>();
        if (!"".equals(object.optString("result", ""))) {
            JSONArray array = object.optJSONArray("result");
            int i = 0;
            while (i < array.length()) {
                GameRecommendInfo info = new GameRecommendInfo();
                info.decodeRecommend(array.optJSONObject(i));
                infos.add(info);
                ++i;
            }
        }
        return infos;
    }

    private List<GameListInfo> decodeGameInfo(JSONObject object) throws Exception {
        ArrayList<GameListInfo> infos = new ArrayList<GameListInfo>();
        JSONArray array = object.optJSONArray("list");
        if (array == null) {
            return infos;
        }
        GameListInfo info = null;
        int i = 0;
        while (i < array.length()) {
            JSONObject obj = array.optJSONObject(i);
            if (obj.optInt("type", -1) == 0 || obj.optInt("type", -1) == 1) {
                info = new GameListInfo();
                info.unmashalGameInfo(obj);
                infos.add(info);
            }
            ++i;
        }
        return infos;
    }

    private void decodeGameList(JSONObject object) throws Exception {
        System.out.println("==decodeGameList==" + object.toString());
        List<GameListInfo> talkInfos = this.decodeGameInfo(object);
        this.mHttpMsg.despatch(talkInfos, null, null, this.type, this.pageIndex, 0);
    }
}

