/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.IntegralGood;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class IntegralMarketRequest
extends BaseRequstClass
implements IHttpUrl,
IHttpListener {
    public static final String TAG = "IntegralMarketRequest";
    private HttpMsg mHttpMsg;
    private HttpConnect conn;
    private int type;
    private int pageIndex;
    private int orderBy;

    public IntegralMarketRequest(Context context, HttpMsg httpMsg, int type) {
        this.mHttpMsg = httpMsg;
        this.type = type;
        String url = "";
        switch (type) {
            case 1801: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.getGoodsList";
                break;
            }
            case 1802: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.getGoodsDetail";
                break;
            }
            case 1803: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.getBuyList";
                break;
            }
            case 1804: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.getAddress";
                break;
            }
            case 1805: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.exchangeGoods";
                break;
            }
            case 1806: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.exchangeBean";
                break;
            }
            case 1807: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.getOrderList";
                break;
            }
            case 1808: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.submitComment";
                break;
            }
            case 1809: {
                url = "http://mob.imlianai.com/call.do?cmd=goods.getScore";
                break;
            }
            default: {
                url = "http://mob.imlianai.com/call.do?cmd=";
            }
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestGetGoodsList(String uid, int pageIndex, int orderBy) {
        byte[] data = null;
        try {
            this.pageIndex = pageIndex;
            this.orderBy = orderBy;
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("pageIndex", pageIndex);
            o.put("orderBy", orderBy);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestGetGoodsDetail(String uid, int goodsCode, int pageIndex) {
        byte[] data = null;
        try {
            this.pageIndex = pageIndex;
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("goodsCode", goodsCode);
            o.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestGetCanExchangeGoods(String uid, int pageIndex) {
        byte[] data = null;
        try {
            this.pageIndex = pageIndex;
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestGetAdress(String uid) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestExchangeGoods(String uid, String firstAddress, String detailAdress, String consignee, String telephone, String zipCode, boolean change, int goodsCode) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("firstAddress", (Object)firstAddress);
            o.put("detailAdress", (Object)detailAdress);
            o.put("consignee", (Object)consignee);
            o.put("telephone", (Object)telephone);
            o.put("zipCode", (Object)zipCode);
            o.put("goodsCode", goodsCode);
            if (change) {
                o.put("change", (Object)"change");
            } else {
                o.put("change", (Object)"1");
            }
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestExchangeBeans(String uid, int goodsCode, int point) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("goodsCode", goodsCode);
            o.put("point", point);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestGetOrderList(String uid, int pageIndex) {
        byte[] data = null;
        try {
            this.pageIndex = pageIndex;
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestSubmitEvaluation(String uid, int id, String commentDetail, String picName) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("id", id);
            o.put("uid", (Object)uid);
            o.put("commentDetail", (Object)commentDetail);
            o.put("picName", (Object)picName);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestScore(String uid) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 1801: {
                        this.decodeList(ob);
                        break;
                    }
                    case 1802: {
                        this.decodeDetail(ob);
                        break;
                    }
                    case 1803: {
                        this.decodeList(ob);
                        break;
                    }
                    case 1804: {
                        this.decodeAddress(ob);
                        break;
                    }
                    case 1805: 
                    case 1806: 
                    case 1808: {
                        this.mHttpMsg.despatch(ob.optString("result"), null, null, this.type, 0, 0);
                        break;
                    }
                    case 1807: {
                        this.decodeOrderForm(ob);
                        break;
                    }
                    case 1809: {
                        this.mHttpMsg.despatch(null, null, null, this.type, 0, ob.optInt("score"));
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                String msg = ob.optString("msg", "");
                this.errInfo(this.mHttpMsg, this.type, result, msg);
            }
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void decodeList(JSONObject object) throws Exception {
        String result = object.optString("result");
        int score = object.optInt("score");
        if (MyTool.stringValid(result)) {
            ArrayList<IntegralGood> list = new ArrayList<IntegralGood>();
            JSONArray arr = new JSONArray(result);
            int i = 0;
            while (i < arr.length()) {
                IntegralGood data = new IntegralGood();
                data.analysisList(arr.optJSONObject(i));
                list.add(data);
                ++i;
            }
            this.mHttpMsg.despatch(list, score, null, this.type, this.pageIndex, this.orderBy);
        } else {
            this.mHttpMsg.despatch(null, score, null, this.type, this.pageIndex, this.orderBy);
        }
    }

    private void decodeDetail(JSONObject object) throws Exception {
        String result = object.optString("result");
        IntegralGood rtData = new IntegralGood();
        ArrayList<IntegralGood> list = new ArrayList<IntegralGood>();
        if (MyTool.stringValid(result)) {
            rtData.analysisDetail(new JSONObject(result));
        } else {
            rtData = null;
        }
        result = object.optString("comments");
        if (MyTool.stringValid(result)) {
            JSONArray arr = new JSONArray(result);
            int i = 0;
            while (i < arr.length()) {
                IntegralGood data = new IntegralGood();
                data.analysisEvaluation(arr.optJSONObject(i));
                list.add(data);
                ++i;
            }
        } else {
            list = null;
        }
        this.mHttpMsg.despatch(rtData, list, null, this.type, this.pageIndex, object.optInt("commentsSize", 0));
    }

    private void decodeAddress(JSONObject object) throws Exception {
        String result = object.optString("result");
        if (MyTool.stringValid(result)) {
            JSONObject arr = new JSONObject(result);
            IntegralGood data = new IntegralGood();
            data.analysisAddress(arr);
            this.mHttpMsg.despatch(data, null, null, this.type, this.pageIndex, 0);
        } else {
            this.mHttpMsg.despatch(null, null, null, this.type, this.pageIndex, 0);
        }
    }

    private void decodeOrderForm(JSONObject object) throws Exception {
        String result = object.optString("result");
        if (MyTool.stringValid(result)) {
            ArrayList<IntegralGood> list = new ArrayList<IntegralGood>();
            JSONArray arr = new JSONArray(result);
            int i = 0;
            while (i < arr.length()) {
                IntegralGood data = new IntegralGood();
                data.analysisOrderForm(arr.optJSONObject(i));
                list.add(data);
                ++i;
            }
            this.mHttpMsg.despatch(list, null, null, this.type, this.pageIndex, 0);
        } else {
            this.mHttpMsg.despatch(null, null, null, this.type, this.pageIndex, 0);
        }
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }
}

