/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.ProfitInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProfitOperation
extends BaseRequstClass
implements IHttpUrl,
IHttpListener {
    private int type;
    private HttpConnect conn;
    private HttpMsg mHttpMsg;
    private String TAG;
    private int pageIndex;

    public ProfitOperation(Context context, HttpMsg httpMsg, int type) {
        this.type = type;
        String url = "http://mob.imlianai.com/call.do?cmd=";
        switch (type) {
            case 6060: {
                url = "http://mob.imlianai.com/call.do?cmd=coin.getWithdrawInfo";
                break;
            }
            case 6061: {
                url = "http://mob.imlianai.com/call.do?cmd=coin.getCoinExchangeList";
                break;
            }
            case 6062: {
                url = "http://mob.imlianai.com/call.do?cmd=coin.coinExchange";
                break;
            }
            case 6063: {
                url = "http://mob.imlianai.com/call.do?cmd=coin.boundWechat";
                break;
            }
            case 6064: {
                url = "http://mob.imlianai.com/call.do?cmd=coin.handleWithdraw";
                break;
            }
            case 6065: {
                url = "http://mob.imlianai.com/call.do?cmd=coin.getWithdrawRecord";
                break;
            }
        }
        this.TAG = this.getClass().getName();
        this.mHttpMsg = httpMsg;
        Log.v((String)this.TAG, (String)url);
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestActions(Map<String, Object> map) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)this.TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestActionsWithPageIndex(Map<String, Object> map, int pageIndex) {
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)this.TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        String tmp = Tools.seekSep((InputStream)in);
        Log.v((String)this.TAG, (String)tmp);
        try {
            JSONObject object = new JSONObject(tmp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 6060: {
                        ProfitInfo info = new ProfitInfo();
                        info.decodeDrawInfo(object);
                        this.mHttpMsg.despatch(info, null, null, this.type, 0, 0);
                        break;
                    }
                    case 6061: {
                        this.returnProfitList(object);
                        break;
                    }
                    case 6062: {
                        this.mHttpMsg.despatch("\u5151\u6362\u6210\u529f", null, null, this.type, object.optInt("remainCoin", 0), 0);
                        break;
                    }
                    case 6063: {
                        this.mHttpMsg.despatch(object.optString("msg", ""), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 6064: {
                        this.mHttpMsg.despatch(object.optString("msg", ""), null, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 6065: {
                        this.returnProfitHistory(object);
                        break;
                    }
                }
            } else {
                int result = object.optInt("result");
                String msg = object.optString("msg");
                if (msg == null || msg.equals("")) {
                    this.mHttpMsg.handleErrorInfo("", result, this.type);
                } else {
                    this.errInfo(this.mHttpMsg, this.type, result, msg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errInfo(this.mHttpMsg, this.type, 0, "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
        }
    }

    private void returnProfitHistory(JSONObject object) {
        String result = object.optString("result");
        ArrayList<ProfitInfo> infos = new ArrayList<ProfitInfo>();
        if (result != null && !result.equals("") && !result.equals("null")) {
            try {
                JSONArray array = new JSONArray(result);
                int i = 0;
                while (i < array.length()) {
                    JSONObject obj = array.optJSONObject(i);
                    ProfitInfo info = new ProfitInfo();
                    info.decodeHistory(obj);
                    infos.add(info);
                    ++i;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.mHttpMsg.despatch(infos, object.optInt("totalAmt", 0), null, this.type, this.pageIndex, 0);
    }

    private void returnProfitList(JSONObject object) {
        String result = object.optString("result");
        ArrayList<ProfitInfo> infos = new ArrayList<ProfitInfo>();
        if (result != null && !result.equals("") && !result.equals("null")) {
            try {
                JSONArray array = new JSONArray(result);
                int i = 0;
                while (i < array.length()) {
                    JSONObject obj = array.optJSONObject(i);
                    ProfitInfo info = new ProfitInfo();
                    info.decodeProfitInfo(obj);
                    infos.add(info);
                    ++i;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.mHttpMsg.despatch(infos, null, null, this.type, this.pageIndex, 0);
    }
}

