/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.UserInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class RelationOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    Context context;
    public static final String TAG = "ReportBlackOperation";
    public HttpConnect conn = null;
    private int type;
    private int position;
    private String mCallBack = "";

    public RelationOperation(Context context, HttpMsg httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = "";
        if (type == 1401 || type == 1402 || type == 1403 || type == 1406 || type == 1407 || type == 1450) {
            url = "http://mob.imlianai.com/call.do?cmd=mobile.getContacts";
        }
        if (url == null) {
            url = "http://mob.imlianai.com/call.do?cmd=";
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void getBlackList(String uid, int pageIndex) {
        this.position = pageIndex;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("type", 6);
            o.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getBlackRelation(String uid, String tid) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("type", 17);
            o.put("tid", (Object)tid);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void addBlack(String uid, String tid, String loginKey) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("type", 7);
            o.put("tid", (Object)tid);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void addCancelAtten(String uid, int type, String tid, String loginKey, String chatroom) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("type", type);
            o.put("tid", (Object)tid);
            o.put("loginKey", (Object)loginKey);
            if (chatroom != null) {
                o.put("chatroom", (Object)chatroom);
            }
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void addChannelAtten(String uid, String tid, String loginKey) {
        byte[] data = null;
        this.mCallBack = tid;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("type", 4);
            o.put("tid", (Object)tid);
            o.put("loginKey", (Object)loginKey);
            o.put("from", 1);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void removeBlack(String uid, String tid, int position, String loginKey) {
        this.position = position;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("type", 8);
            o.put("tid", (Object)tid);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.getBoolean("state");
            if (state) {
                switch (this.type) {
                    case 1401: {
                        String black = ob.getString("result");
                        if (MyTool.stringValid(black)) {
                            JSONArray arr = new JSONArray(black);
                            ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
                            int i = 0;
                            while (i < arr.length()) {
                                JSONObject obj = arr.getJSONObject(i);
                                UserInfo userInfo = new UserInfo();
                                userInfo.unmashalBlackList(obj);
                                userInfos.add(userInfo);
                                ++i;
                            }
                            this.httpMsg.despatch(userInfos, null, null, this.type, this.position, 0);
                            break;
                        }
                        this.httpMsg.despatch(null, null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1402: {
                        this.httpMsg.despatch(null, null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1403: {
                        this.httpMsg.despatch(null, null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1406: {
                        this.httpMsg.despatch(ob.optString("msg"), this.mCallBack, null, this.type, this.position, 0);
                        break;
                    }
                    case 1407: {
                        this.httpMsg.despatch(null, null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1450: {
                        this.httpMsg.despatch(null, null, null, this.type, ob.optInt("result", -1), 0);
                        break;
                    }
                    default: {
                        this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u9519\u8bef", 0, this.type);
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                this.userErrInfo(result, ob.optString("msg", ""));
            }
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

