/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.GiftInfo;
import com.cn.anddev.andengine.model.GiftInfoExtra;
import com.cn.anddev.andengine.model.ScenceInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScenceOperation
extends BaseRequstClass
implements IHttpUrl,
IHttpListener {
    private int type;
    private HttpConnect conn;
    private HttpMsg mHttpMsg;
    private String TAG = this.getClass().getName();
    private int pageIndex;

    public ScenceOperation(Context context, HttpMsg httpMsg, String url) {
        this.mHttpMsg = httpMsg;
        Log.v((String)this.TAG, (String)url);
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestActions(int action, Map<String, Object> map, int pageIndex) {
        this.type = action;
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)this.TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        String tmp = Tools.seekSep((InputStream)in);
        Log.v((String)this.TAG, (String)tmp);
        try {
            JSONObject object = new JSONObject(tmp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 5300: {
                        this.mHttpMsg.despatch(this.decodeListInfo(object, true), object.optInt("bean", 0), object.optInt("diamond", 0), this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5301: {
                        this.mHttpMsg.despatch(this.decodeListInfo(object, false), object.optInt("bean", 0), object.optInt("diamond", 0), this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5302: {
                        this.mHttpMsg.despatch(this.decodeMineScenceInfo(object, "carScene"), this.decodeMineScenceInfo(object, "vipScene"), null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 5303: {
                        this.mHttpMsg.despatch(object.optInt("stopType", 0), object.optString("result", ""), object.optString("picUrls", ""), this.type, this.pageIndex, object.optInt("sceneCode", 0));
                        break;
                    }
                    case 5304: {
                        this.returnCarScenceDetail(object);
                        break;
                    }
                    case 5305: {
                        this.returnVipScenceDetail(object);
                        break;
                    }
                }
            } else {
                int result = object.optInt("result");
                String msg = object.optString("msg");
                if (msg == null || msg.equals("")) {
                    this.mHttpMsg.handleErrorInfo("", result, this.type);
                } else {
                    this.errInfo(this.mHttpMsg, this.type, result, msg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errInfo(this.mHttpMsg, this.type, 0, "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
        }
    }

    private void returnCarScenceDetail(JSONObject ob) throws JSONException {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        GiftInfoExtra gInfoExtra = new GiftInfoExtra();
        gInfoExtra.analyzePropExtra(ob.optJSONObject("info"));
        if (MyTool.stringValid(result)) {
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.analyzeProp(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.mHttpMsg.despatch(giftInfos, gInfoExtra, null, this.type, this.pageIndex, 0);
    }

    private void returnVipScenceDetail(JSONObject object) {
        ScenceInfo info = new ScenceInfo();
        info.decodeVipDetail(object.optJSONObject("info"));
        this.mHttpMsg.despatch(info, null, null, this.type, this.pageIndex, 0);
    }

    private List<ScenceInfo> decodeListInfo(JSONObject object, boolean car) {
        ArrayList<ScenceInfo> infos = new ArrayList<ScenceInfo>();
        JSONArray array = null;
        array = car ? object.optJSONArray("car") : object.optJSONArray("scene");
        if (array == null) {
            return infos;
        }
        ScenceInfo info = null;
        int i = 0;
        while (i < array.length()) {
            JSONObject obj = array.optJSONObject(i);
            info = new ScenceInfo();
            if (car) {
                info.decodeSecnceCarInfo(obj);
            } else {
                info.decodeScenceVipInfo(obj);
            }
            infos.add(info);
            ++i;
        }
        return infos;
    }

    private List<ScenceInfo> decodeMineScenceInfo(JSONObject object, String key) {
        ArrayList<ScenceInfo> infos = new ArrayList<ScenceInfo>();
        JSONArray array = object.optJSONArray(key);
        if (array == null) {
            return infos;
        }
        ScenceInfo info = null;
        int i = 0;
        while (i < array.length()) {
            JSONObject obj = array.optJSONObject(i);
            info = new ScenceInfo();
            info.decodeScenceMine(obj);
            infos.add(info);
            ++i;
        }
        return infos;
    }
}

