/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.UserInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class XiehouRequest
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    private int type;
    private HttpConnect conn;
    private String TAG = "XiehouRequest";

    public XiehouRequest(Context context, HttpMsg httpMsg, int urlType) {
        this.httpMsg = httpMsg;
        this.type = urlType;
        String url = "";
        url = "http://mob.imlianai.com/call.do?cmd=mobileChance.user";
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void getXiehou(String uid, int gender, int label, ArrayList<Long> noUids, int seconds, int city, int cityCode) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("gender", gender);
            object.put("label", label);
            if (cityCode >= 0) {
                object.put("cityCode", cityCode);
            }
            if (city > 0) {
                object.put("city", city);
            }
            if (seconds != 0) {
                object.put("seconds", seconds);
            }
            if (noUids.size() != 0) {
                JSONArray arr = new JSONArray();
                int i = 0;
                while (i < noUids.size()) {
                    arr.put((Object)noUids.get(i));
                    ++i;
                }
                object.put("noUids", (Object)arr);
            }
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getXiehou(String uid, double longitude, double latitude, int gender, int label, ArrayList<Long> noUids, int seconds, int city, int cityCode) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("longitude", longitude);
            object.put("latitude", latitude);
            object.put("gender", gender);
            object.put("label", label);
            if (cityCode >= 0) {
                object.put("cityCode", cityCode);
            }
            if (city > 0) {
                object.put("city", city);
            }
            if (seconds != 0) {
                object.put("seconds", seconds);
            }
            if (noUids.size() != 0) {
                JSONArray arr = new JSONArray();
                int i = 0;
                while (i < noUids.size()) {
                    arr.put((Object)noUids.get(i));
                    ++i;
                }
                object.put("noUids", (Object)arr);
            }
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        block11: {
            try {
                String temp = Tools.seekSep((InputStream)in);
                Log.v((String)this.TAG, (String)temp);
                JSONObject ob = new JSONObject(temp);
                boolean state = ob.getBoolean("state");
                if (state) {
                    ArrayList<Long> uids = new ArrayList<Long>();
                    JSONArray uidArr = ob.optJSONArray("noUids");
                    int i = 0;
                    while (i < uidArr.length()) {
                        uids.add(uidArr.optLong(i));
                        ++i;
                    }
                    String result = ob.optString("result");
                    int topType = ob.optInt("topType", -1);
                    String topList = ob.optString("topList", "");
                    ArrayList<String> images = null;
                    int ballNormal = ob.optInt("ballNormal", 0);
                    if (MyTool.stringValid(topList)) {
                        images = new ArrayList<String>();
                        try {
                            JSONArray jsonArray = ob.optJSONArray("topList");
                            int y = 0;
                            while (y < jsonArray.length()) {
                                images.add(jsonArray.optString(y));
                                ++y;
                            }
                        }
                        catch (Exception jsonArray) {
                            // empty catch block
                        }
                    }
                    if (MyTool.stringValid(result)) {
                        UserInfo info = new UserInfo();
                        List<UserInfo> userNear = info.decodeContactsXiehou(ob);
                        this.httpMsg.despatch(userNear, uids, images, this.type, ballNormal, topType);
                    } else {
                        this.httpMsg.despatch(null, uids, images, this.type, ballNormal, topType);
                    }
                    break block11;
                }
                int result = ob.optInt("result");
                String msg = ob.optString("msg");
                if (msg != null && !msg.equals("") && !msg.equals("null")) {
                    this.httpMsg.handleErrorInfo(msg, result, this.type);
                    return;
                }
                this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
            }
            catch (Exception e) {
                this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
            }
        }
    }
}

