/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.BriberyMoneyInfo;
import com.cn.anddev.andengine.model.ChatGroupAbout;
import com.cn.anddev.andengine.model.ChatGroupInfo;
import com.cn.anddev.andengine.model.ChatGroupMessageInfo;
import com.cn.anddev.andengine.model.PayInfo;
import com.cn.anddev.andengine.model.UserInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChatGroupOperation
extends BaseRequstClass
implements IHttpUrl,
IHttpListener {
    private int type;
    private HttpConnect conn;
    private HttpMsg mHttpMsg;
    private String TAG = "ChatGroupOperation";
    private int callbackInt;
    private Object callbackData;
    private JSONObject jsonObject;

    public ChatGroupOperation(Context context, HttpMsg httpMsg, String url, int type) {
        this.type = type;
        this.mHttpMsg = httpMsg;
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestActions(Map<String, Object> map, int callbackInt, Object callbackData) {
        this.callbackData = callbackData;
        this.callbackInt = callbackInt;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            this.jsonObject = obj;
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestActions(JSONObject jsonObject, int callbackInt, Object callbackData) {
        this.callbackData = callbackData;
        this.callbackInt = callbackInt;
        this.jsonObject = jsonObject;
        byte[] data = null;
        try {
            data = DESencryption.getEncString((String)jsonObject.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }

    private void returnGroupInfo(String result) {
        try {
            ChatGroupInfo chatGroupInfo = new ChatGroupInfo();
            JSONObject jsonObject = new JSONObject(result);
            chatGroupInfo.parsingInfo(jsonObject);
            this.mHttpMsg.despatch(chatGroupInfo, this.callbackData, this.callbackData, this.type, 0, this.callbackInt);
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnChatGroupInfoDetail(JSONObject object) {
        ChatGroupInfo chatGroupInfo = new ChatGroupInfo();
        chatGroupInfo.decodeGroupInfoDetail(object);
        this.mHttpMsg.despatch(chatGroupInfo, null, null, this.type, 0, this.callbackInt);
    }

    private void returnAboutInfo(JSONObject object) {
        ChatGroupAbout about = new ChatGroupAbout();
        if (!object.optString("result").equals("") && object.optString("result") != null) {
            about.decodeAboutInfo(object.optJSONObject("result"));
        }
        this.mHttpMsg.despatch(about, null, null, this.type, 0, this.callbackInt);
    }

    private void returnGroupMember(JSONObject object) {
        ArrayList<UserInfo> infos = new ArrayList<UserInfo>();
        if (!object.optString("result").equals("") && object.optString("") != null) {
            JSONArray array = object.optJSONArray("result");
            int i = 0;
            while (i < array.length()) {
                UserInfo info = new UserInfo();
                info.decodeFslData(array.optJSONObject(i));
                infos.add(info);
                ++i;
            }
        }
        this.mHttpMsg.despatch(infos, null, null, this.type, 0, this.callbackInt);
    }

    private void returnGroupList(String result) {
        try {
            ArrayList<ChatGroupInfo> chatGroupInfos = new ArrayList<ChatGroupInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    ChatGroupInfo chatGroupInfo = new ChatGroupInfo();
                    chatGroupInfo.parsingInfo(jsonObject);
                    chatGroupInfos.add(chatGroupInfo);
                    ++i;
                }
            }
            this.mHttpMsg.despatch(chatGroupInfos, this.callbackData, this.callbackData, this.type, this.callbackInt, this.callbackInt);
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnPackteList(JSONObject jsonObject) {
        try {
            String records = jsonObject.optString("records", "");
            BriberyMoneyInfo myBriberyMoneyInfo = null;
            ArrayList<BriberyMoneyInfo> briberyMoneyInfos = new ArrayList<BriberyMoneyInfo>();
            if (MyTool.stringValid(records)) {
                JSONArray jsonArray = new JSONArray(records);
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    JSONObject jsonObject2 = jsonArray.getJSONObject(i);
                    BriberyMoneyInfo briberyMoneyInfo = new BriberyMoneyInfo();
                    briberyMoneyInfo.paresingRecord(jsonObject2);
                    briberyMoneyInfos.add(briberyMoneyInfo);
                    ++i;
                }
            }
            if (this.callbackInt == 1) {
                JSONObject myJsonObject = new JSONObject(jsonObject.optString("packet", ""));
                myBriberyMoneyInfo = new BriberyMoneyInfo();
                myBriberyMoneyInfo.parsingInfo(myJsonObject);
                myBriberyMoneyInfo.setDiamond(jsonObject.optInt("jewelGet", 0));
            }
            this.mHttpMsg.despatch(briberyMoneyInfos, myBriberyMoneyInfo, null, this.type, this.callbackInt, this.callbackInt);
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnMessageList(String result, int noReadNum, String groupUser, int groupNum) {
        try {
            ArrayList<ChatGroupMessageInfo> chatGroupMessageInfos = new ArrayList<ChatGroupMessageInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    ChatGroupMessageInfo chatGroupMessageInfo = new ChatGroupMessageInfo();
                    chatGroupMessageInfo.parsingInfo(jsonObject);
                    if (this.type == 6019 && chatGroupMessageInfo.getType() == 3) {
                        chatGroupMessageInfo.setHasPlay(1);
                    }
                    if (this.type == 6019 && i == 0) {
                        chatGroupMessageInfo.setNewTag(1);
                    }
                    if (this.isMytype(chatGroupMessageInfo.getType())) {
                        chatGroupMessageInfos.add(chatGroupMessageInfo);
                    }
                    ++i;
                }
            }
            this.mHttpMsg.despatch(chatGroupMessageInfos, groupUser, null, this.type, noReadNum, groupNum);
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private boolean isMytype(int type) {
        return type > 0 && type < 8 || type > 9 && type < 12;
    }

    private void returnMoneyList(String mobileChargeList) {
        try {
            ArrayList<PayInfo> payInfos = new ArrayList<PayInfo>();
            if (MyTool.stringValid(mobileChargeList)) {
                JSONArray jsonArray = new JSONArray(mobileChargeList);
                int size = jsonArray.length();
                int i = 0;
                while (i < size) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    PayInfo payInfo = new PayInfo();
                    payInfo.parsingBriberyMoney(jsonObject);
                    payInfos.add(payInfo);
                    ++i;
                }
            }
            this.mHttpMsg.despatch(payInfos, null, null, this.type, this.callbackInt, this.callbackInt);
        }
        catch (Exception e) {
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    public void decode(InputStream in) throws IOException {
        String tmp = Tools.seekSep((InputStream)in);
        Log.v((String)this.TAG, (String)tmp);
        try {
            JSONObject object = new JSONObject(tmp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 6001: {
                        this.mHttpMsg.despatch(object.optString("result", ""), this.callbackData, this.callbackData, this.type, object.optInt("userNumMax", 1), this.callbackInt);
                        break;
                    }
                    case 6002: {
                        this.returnGroupInfo(object.optString("result", ""));
                        break;
                    }
                    case 6003: {
                        this.returnGroupList(object.optString("result", ""));
                        break;
                    }
                    case 6023: {
                        UserInfo userInfo = new UserInfo();
                        userInfo.parsingChatroomUserinfo(object);
                        ChatGroupMessageInfo chatGroupMessageInfo = (ChatGroupMessageInfo)this.callbackData;
                        userInfo.setUid(chatGroupMessageInfo.getUid());
                        userInfo.setHead(chatGroupMessageInfo.getHead());
                        this.mHttpMsg.despatch(userInfo, this.callbackData, this.callbackData, this.type, this.callbackInt, this.callbackInt);
                        break;
                    }
                    case 6028: {
                        this.mHttpMsg.despatch(null, this.callbackData, this.callbackData, this.type, object.optInt("packetState", 0), 0);
                        break;
                    }
                    case 6007: {
                        this.mHttpMsg.despatch(null, null, null, this.type, object.optInt("jewelGet", 0), 0);
                        break;
                    }
                    case 6024: {
                        this.returnPackteList(object);
                        break;
                    }
                    case 6005: {
                        this.returnMoneyList(object.optString("mobileChargeList", ""));
                        break;
                    }
                    case 6025: {
                        this.mHttpMsg.despatch(object.optString("orderInfo", ""), null, null, this.type, 0, 0);
                        break;
                    }
                    case 6006: {
                        this.mHttpMsg.despatch(tmp, null, null, this.type, 0, 0);
                        break;
                    }
                    case 6017: {
                        this.returnMessageList(object.optString("result", ""), object.optInt("noReadNum", 0), object.optString("groupUser", ""), object.optInt("groupUserNum", 0));
                        break;
                    }
                    case 6018: {
                        this.returnMessageList(object.optString("result", ""), 0, "", 0);
                        break;
                    }
                    case 6019: {
                        this.returnMessageList(object.optString("result", ""), 0, "", 0);
                        break;
                    }
                    case 6008: {
                        this.returnChatGroupInfoDetail(object);
                        break;
                    }
                    case 6009: 
                    case 6013: 
                    case 6014: 
                    case 6015: 
                    case 6020: 
                    case 6021: 
                    case 6022: {
                        this.mHttpMsg.despatch(object.optString("result", ""), null, null, this.type, 0, 0);
                        break;
                    }
                    case 6011: {
                        this.mHttpMsg.despatch(object.optInt("userNum", 0), null, null, this.type, 0, 0);
                        break;
                    }
                    case 6026: {
                        this.returnAboutInfo(object);
                        break;
                    }
                    case 6027: {
                        this.mHttpMsg.despatch(this.callbackData, null, null, this.type, 0, 0);
                        break;
                    }
                    case 6010: {
                        this.returnGroupMember(object);
                        break;
                    }
                    case 6012: {
                        this.mHttpMsg.despatch(this.callbackData, null, null, this.type, 0, 0);
                        break;
                    }
                    case 6029: {
                        this.mHttpMsg.despatch(object.optString("groupIds", ""), object.optString("groupMsgs", ""), null, this.type, 0, 0);
                        break;
                    }
                }
            } else {
                int result = object.optInt("result");
                if (result == 601) {
                    this.mHttpMsg.despatch(this.jsonObject, this.callbackData, this.type, 100002, object.optInt("costJewel", -1), object.optInt("costBean", -1));
                } else {
                    this.userErrInfo(result, object.optString("msg", ""));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mHttpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.mHttpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.mHttpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

