/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.FeedBackInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class FeedbackOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    Context context;
    public static final String TAG = "FeedbackOperation";
    public HttpConnect conn = null;
    private int type;
    private int pageIndex;
    private int position;
    private int satisfy;

    public FeedbackOperation(Context context, HttpMsg httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = null;
        switch (type) {
            case 1502: {
                url = "http://mob2.imlianai.com/call.do?cmd=service.submitFeedback";
                break;
            }
            case 1504: {
                url = "http://mob2.imlianai.com/call.do?cmd=service.getReplyList";
                break;
            }
            case 1501: {
                url = "http://mob2.imlianai.com/call.do?cmd=service.getFeedbackList";
                break;
            }
            case 1503: {
                url = "http://mob2.imlianai.com/call.do?cmd=service.submitReply";
                break;
            }
            case 1505: {
                url = "http://mob2.imlianai.com/call.do?cmd=service.submitSatisfy";
                break;
            }
        }
        if (url == null) {
            url = "http://mob2.imlianai.com/call.do?cmd=";
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void getFeedbackList(String uid, int pageIndex) {
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void addFeedback(FeedBackInfo backInfo) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)backInfo.getUid());
            o.put("type", backInfo.getType());
            if (backInfo.getImage() != null) {
                o.put("filename", (Object)backInfo.getImage());
            }
            o.put("content", (Object)backInfo.getContent());
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void replyFeedback(FeedBackInfo backInfo, int id) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)backInfo.getUid());
            o.put("feedbackId", id);
            o.put("reply_content", (Object)backInfo.getContent());
            if (backInfo.getImage() != null) {
                o.put("filename", (Object)backInfo.getImage());
            }
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void updateFeedbackReply(String uid, int satisfy, int id, int position) {
        this.position = position;
        this.satisfy = satisfy;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("id", id);
            o.put("satisfy", satisfy);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getFeedbackDetail(String uid, int id, int pageIndex) {
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("feedbackId", id);
            o.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        block17: {
            try {
                String temp = Tools.seekSep((InputStream)in);
                Log.v((String)TAG, (String)temp);
                JSONObject ob = new JSONObject(temp);
                boolean state = ob.getBoolean("state");
                if (state) {
                    switch (this.type) {
                        case 1502: {
                            this.httpMsg.despatch(null, null, null, this.type, 0, 0);
                            break;
                        }
                        case 1504: {
                            FeedBackInfo myfeedBackInfo = null;
                            if (this.pageIndex == 1) {
                                try {
                                    JSONObject jsonObject = new JSONObject(ob.optString("feedback"));
                                    myfeedBackInfo = new FeedBackInfo();
                                    myfeedBackInfo.parsingFeedbackInfo(jsonObject);
                                }
                                catch (Exception e) {
                                    myfeedBackInfo = null;
                                }
                            }
                            String result = ob.optString("result");
                            ArrayList<FeedBackInfo> feedBackreplyInfos = new ArrayList<FeedBackInfo>();
                            if (MyTool.stringValid(result)) {
                                JSONArray jsonArray = new JSONArray(ob.optString("result"));
                                int size = jsonArray.length();
                                int i = 0;
                                while (i < size) {
                                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                                    FeedBackInfo feedBackInfo = new FeedBackInfo();
                                    feedBackInfo.pasingFeedreplyInfo(jsonObject);
                                    feedBackreplyInfos.add(feedBackInfo);
                                    ++i;
                                }
                            }
                            this.httpMsg.despatch(feedBackreplyInfos, myfeedBackInfo, null, this.type, this.pageIndex, 0);
                            break;
                        }
                        case 1503: {
                            this.httpMsg.despatch(null, null, null, this.type, this.pageIndex, 0);
                            break;
                        }
                        case 1501: {
                            ArrayList<FeedBackInfo> feedBackInfos = new ArrayList<FeedBackInfo>();
                            if (MyTool.stringValid(ob.optString("result"))) {
                                JSONArray jsonArray = new JSONArray(ob.optString("result"));
                                int size = jsonArray.length();
                                int i = 0;
                                while (i < size) {
                                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                                    FeedBackInfo feedBackInfo = new FeedBackInfo();
                                    feedBackInfo.parsingFeedbackInfo(jsonObject);
                                    feedBackInfos.add(feedBackInfo);
                                    ++i;
                                }
                            }
                            this.httpMsg.despatch(feedBackInfos, null, null, this.type, this.pageIndex, 0);
                            break;
                        }
                        case 1505: {
                            this.httpMsg.despatch(null, null, null, this.type, this.position, this.satisfy);
                            break;
                        }
                        default: {
                            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u9519\u8bef", 0, this.type);
                            break;
                        }
                    }
                    break block17;
                }
                int result = ob.optInt("result");
                this.userErrInfo(result, ob.optString("msg", ""));
            }
            catch (Exception e) {
                this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
            }
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

