/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg_Gift_Trade;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.CharmPointInfo;
import com.cn.anddev.andengine.model.GiftInfo;
import com.cn.anddev.andengine.model.GiftInfoExtra;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GiftPropOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg_Gift_Trade httpMsg;
    Context context;
    public static final String TAG = "GiftPropOperation";
    public HttpConnect conn = null;
    private int type;
    private int pageIndex;
    private int position = 0;
    private GiftInfo giftInfo;

    public GiftPropOperation(Context context, HttpMsg_Gift_Trade httpMsg, int type) {
        this.init(context, httpMsg, type, false);
    }

    public GiftPropOperation(Context context, HttpMsg_Gift_Trade httpMsg, int type, boolean isHandMarket) {
        this.init(context, httpMsg, type, isHandMarket);
    }

    public void init(Context context, HttpMsg_Gift_Trade httpMsg, int type, boolean isHandMarket) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = null;
        if (isHandMarket) {
            this.position = 1;
            switch (type) {
                case 2107: {
                    url = "http://mob2.imlianai.com/call.do?cmd=hand.buyScene";
                    break;
                }
                case 2106: {
                    url = "http://mob2.imlianai.com/call.do?cmd=hand.updateScene";
                    break;
                }
                case 2104: {
                    url = "http://mob2.imlianai.com/call.do?cmd=hand.sceneShopDetail";
                    break;
                }
                case 2103: {
                    url = "http://mob2.imlianai.com/call.do?cmd=hand.sceneShopList";
                    break;
                }
                case 2105: {
                    url = "http://mob2.imlianai.com/call.do?cmd=hand.myScene";
                    break;
                }
                case 2108: {
                    url = "http://mob2.imlianai.com/call.do?cmd=hand.getUrl";
                    break;
                }
                default: {
                    url = "http://mob2.imlianai.com/call.do?cmd=";
                    break;
                }
            }
        } else {
            switch (type) {
                case 1601: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getMobileGiftList";
                    break;
                }
                case 1602: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getSuperGiftList";
                    break;
                }
                case 1603: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getMobileSceneList";
                    break;
                }
                case 1604: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.sendGift";
                    break;
                }
                case 1605: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getLastGift";
                    break;
                }
                case 1606: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getRecvGiftList";
                    break;
                }
                case 1607: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getTopSenderList";
                    break;
                }
                case 1608: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.sceneShopList";
                    break;
                }
                case 1609: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.sceneShopDetail";
                    break;
                }
                case 1610: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.myScene";
                    break;
                }
                case 1611: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.updateScene";
                    break;
                }
                case 1612: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.buyScene";
                    break;
                }
                case 1614: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.sendTalkGift";
                    break;
                }
                case 6033: {
                    url = "http://mob2.imlianai.com/call.do?cmd=gift.getGiftCoinList";
                    break;
                }
                default: {
                    url = "http://mob2.imlianai.com/call.do?cmd=";
                }
            }
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void getGiftList(String uid, String versionCode, int type, int direction) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            if (type == 1 || type == 2) {
                o.put("versionCode", (Object)versionCode);
            } else {
                o.put("direction", direction);
            }
            o.put("type", type);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void sendGift(String uid, String toUid, int code, String loginKey, boolean broadcast, int giftType, int costJewel, GiftInfo giftInfo, String groupId, boolean isFree) {
        byte[] data = null;
        this.giftInfo = giftInfo;
        try {
            JSONObject o = new JSONObject();
            o.put("fromUid", (Object)uid);
            o.put("toUid", (Object)toUid);
            o.put("giftType", giftType);
            o.put("giftCode", code);
            o.put("loginKey", (Object)loginKey);
            if (groupId != null) {
                o.put("groupId", (Object)groupId);
            }
            if (isFree) {
                o.put("giftFree", (Object)"1");
            }
            if (broadcast) {
                o.put("broadcast", (Object)"broadcast");
            }
            if (costJewel > -1) {
                o.put("costJewel", costJewel);
            }
            data = DESencryption.getEncString((String)o.toString()).getBytes();
            Log.i((String)TAG, (String)o.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getGiftReceive(String uid) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getPropMarket(String uid) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getCharmPointList(String uid, String tid, int page) {
        byte[] data = null;
        this.pageIndex = page;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("page", page);
            if (tid != null && !tid.equals("")) {
                o.put("tid", (Object)tid);
            }
            data = DESencryption.getEncString((String)o.toString()).getBytes();
            Log.i((String)TAG, (String)o.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getPropDetail(String uid, int parentCode) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("parentCode", parentCode);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
            Log.i((String)TAG, (String)o.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getMyProp(String uid) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getModifyPropStatus(String uid, int status, int sceneCode) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("status", status);
            o.put("sceneCode", sceneCode);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getBuyProp(String uid, int sceneCode, String loginKey) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("sceneCode", sceneCode);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getPropUrl(int parentCode) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("parentCode", parentCode);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    private void returnGiftList(JSONObject ob) {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        if (MyTool.stringValid(result)) {
            try {
                JSONArray arr = new JSONArray(result);
                int size = arr.length();
                if (size == 0) {
                    return;
                }
                this.httpMsg.despatch(ob.optInt("diamond", 0), ob.optInt("bean", 0), this.type, this.position);
                if (this.type == 1603) {
                    int i = 0;
                    while (i < size) {
                        JSONObject obj = arr.getJSONObject(i);
                        GiftInfo giftInfo = new GiftInfo();
                        giftInfo.unmashalProps(obj);
                        giftInfos.add(giftInfo);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < size) {
                        JSONObject obj = arr.getJSONObject(i);
                        GiftInfo giftInfo = new GiftInfo();
                        giftInfo.unmashalGift(obj);
                        giftInfos.add(giftInfo);
                        ++i;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.httpMsg.despatch(giftInfos, ob.optInt("giftCodeFree", 0), ob.optInt("giftCodeNum", 0), this.type, ob.optInt("giftFreeNext", 0), this.position);
    }

    private void returnGiftNew(JSONObject ob) throws Exception {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        if (MyTool.stringValid(result)) {
            this.httpMsg.despatch(ob.optInt("totalGiftNum", 0), this.type, 0, this.position);
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.unmashalGiftNew(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(giftInfos, null, null, this.type, this.pageIndex, this.position);
    }

    private void returnGiftAll(JSONObject ob) throws Exception {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        if (MyTool.stringValid(result)) {
            this.httpMsg.despatch(ob.optInt("totalGiftNum", 0), this.type, 0, this.position);
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.unmashalGiftAll(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(giftInfos, null, null, this.type, this.pageIndex, this.position);
    }

    private void returnGiftRank(JSONObject ob) throws Exception {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        if (MyTool.stringValid(result)) {
            this.httpMsg.despatch(ob.optInt("totalGiftNum", 0), this.type, 0, this.position);
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.unmashalGiftRank(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(giftInfos, null, null, this.type, this.pageIndex, this.position);
    }

    private void returnPropMarket(JSONObject ob) throws JSONException {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        if (MyTool.stringValid(result)) {
            this.httpMsg.despatch(ob.optInt("bean", 0), ob.optInt("diamond", 0), this.type, this.position);
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.analyzeProp(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(giftInfos, null, null, this.type, this.pageIndex, this.position);
    }

    private void returnPropDetail(JSONObject ob) throws JSONException {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        GiftInfoExtra gInfoExtra = new GiftInfoExtra();
        gInfoExtra.analyzePropExtra(ob.optJSONObject("info"));
        if (MyTool.stringValid(result)) {
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.analyzeProp(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(giftInfos, gInfoExtra, null, this.type, this.pageIndex, this.position);
    }

    private void returnMyProp(JSONObject ob) throws JSONException {
        String result = ob.optString("result");
        ArrayList<GiftInfo> giftInfos = new ArrayList<GiftInfo>();
        if (MyTool.stringValid(result)) {
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.analyzeMyProp(obj);
                giftInfos.add(giftInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(giftInfos, null, null, this.type, this.pageIndex, this.position);
    }

    private void returnCharmPoint(JSONObject ob) throws JSONException {
        String result = ob.optString("result");
        ArrayList<CharmPointInfo> infos = new ArrayList<CharmPointInfo>();
        if (MyTool.stringValid(result)) {
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                CharmPointInfo charmPointInfo = new CharmPointInfo();
                charmPointInfo.decodeCharmPoint(obj);
                infos.add(charmPointInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(infos, ob.optInt("totalCoin"), null, this.type, this.pageIndex, 0);
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.getBoolean("state");
            if (state) {
                switch (this.type) {
                    case 1601: 
                    case 1602: 
                    case 1603: {
                        this.returnGiftList(ob);
                        break;
                    }
                    case 1604: 
                    case 1614: {
                        this.httpMsg.despatch(ob.optInt("diamond", 0), ob.optInt("bean", 0), this.type, this.position);
                        this.httpMsg.despatch(ob.optString("result", "\u8d60\u9001\u6210\u529f"), null, null, this.type, this.pageIndex, this.position);
                        break;
                    }
                    case 1605: {
                        this.returnGiftNew(ob);
                        break;
                    }
                    case 1606: {
                        this.returnGiftAll(ob);
                        break;
                    }
                    case 1607: {
                        this.returnGiftRank(ob);
                        break;
                    }
                    case 1608: 
                    case 2103: {
                        this.returnPropMarket(ob);
                        break;
                    }
                    case 1609: 
                    case 2104: {
                        this.returnPropDetail(ob);
                        break;
                    }
                    case 1610: 
                    case 2105: {
                        this.returnMyProp(ob);
                        break;
                    }
                    case 1611: {
                        this.httpMsg.despatch(ob.optInt("result"), ob.optInt("sceneCode"), ob.optString("picUrls"), this.type, this.pageIndex, this.position);
                        break;
                    }
                    case 2106: 
                    case 2107: {
                        this.httpMsg.despatch(ob.optString("result"), ob.optInt("sceneCode"), ob.optString("picUrls"), this.type, this.pageIndex, ob.optInt("stopType"));
                        break;
                    }
                    case 2108: {
                        this.httpMsg.despatch(ob.optString("result"), ob.optInt("parentCode"), ob.optString("picUrls"), this.type, this.pageIndex, this.position);
                        break;
                    }
                    case 1612: {
                        this.httpMsg.despatch(ob.optString("result"), ob.optInt("sceneCode"), ob.optString("picUrls"), this.type, this.pageIndex, ob.optInt("stopType"));
                        break;
                    }
                    case 6033: {
                        this.returnCharmPoint(ob);
                        break;
                    }
                    default: {
                        this.httpMsg.despatch(null, null, null, this.type, this.pageIndex, this.position);
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                if (result == 601) {
                    this.httpMsg.handlerTradeError(this.giftInfo, result, this.type, ob.optInt("costJewel", -1), ob.optInt("costBean", -1));
                } else {
                    this.userErrInfo(result, ob.optString("msg", ""));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

