/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg_Gift_Trade;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.HydrangeaFreeInfo;
import com.cn.anddev.andengine.model.HydrangeaListInfo;
import com.cn.anddev.andengine.model.MobileBallRecord;
import com.cn.anddev.andengine.model.UserInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HydrangeaOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg_Gift_Trade httpMsg;
    Context context;
    public static final String TAG = "HydrangeaOperation";
    public HttpConnect conn = null;
    private int type;
    private int pageIndex;
    private int position = 0;
    private HydrangeaListInfo hydrangeaListInfo;

    public HydrangeaOperation(Context context, HttpMsg_Gift_Trade httpMsg, int type) {
        this.init(context, httpMsg, type);
    }

    public void init(Context context, HttpMsg_Gift_Trade httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = null;
        switch (type) {
            case 6030: {
                url = "http://mob2.imlianai.com/call.do?cmd=gift.ballGift";
                break;
            }
            case 6031: {
                url = "http://mob2.imlianai.com/call.do?cmd=gift.sendBall";
                break;
            }
            case 6032: {
                url = "http://mob2.imlianai.com/call.do?cmd=mobileBall.list";
                break;
            }
            case 6036: {
                url = "http://mob2.imlianai.com/call.do?cmd=mobileBall.send";
                break;
            }
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void sendDataComm(Map<String, Object> map) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void sendDataCommWithPage(Map<String, Object> map, int pageindex) {
        byte[] data = null;
        this.pageIndex = pageindex;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getHydrangeaList(String uid, String loginKey) {
        byte[] data = null;
        try {
            JSONObject o = new JSONObject();
            o.put("uid", (Object)uid);
            o.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void sendHydrangea(String uid, int code, String loginKey, Boolean broadcast, HydrangeaListInfo hydrangeaListInfo, int costJewel) {
        byte[] data = null;
        this.hydrangeaListInfo = hydrangeaListInfo;
        try {
            JSONObject o = new JSONObject();
            o.put("fromUid", (Object)uid);
            o.put("giftCode", code);
            o.put("loginKey", (Object)loginKey);
            if (broadcast.booleanValue()) {
                o.put("broadcast", (Object)"broadcast");
            }
            if (costJewel > -1) {
                o.put("costJewel", costJewel);
            }
            Log.v((String)TAG, (String)("" + o));
            data = DESencryption.getEncString((String)o.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.getBoolean("state");
            Log.v((String)TAG, (String)(String.valueOf(state) + this.type));
            if (state) {
                switch (this.type) {
                    case 6030: {
                        this.returnHydrangeaList(ob);
                        break;
                    }
                    case 6031: {
                        this.httpMsg.despatch(ob.optString("result", "\u64cd\u4f5c\u6210\u529f"), null, null, this.type, this.pageIndex, this.position);
                        break;
                    }
                    case 6032: {
                        this.returnHydrangeaHistory(ob);
                        break;
                    }
                    case 6036: {
                        this.returnMobileBallSendSuccess(ob);
                        break;
                    }
                    case 6037: {
                        this.returnReciverInfo(ob);
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                if (result == 601) {
                    this.httpMsg.handlerTradeError(this.hydrangeaListInfo, result, this.type, ob.optInt("costJewel", -1), ob.optInt("costBean", -1));
                } else {
                    this.userErrInfo(result, ob.optString("msg", ""));
                }
            }
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnReciverInfo(JSONObject ob) {
        UserInfo userInfo = new UserInfo();
        userInfo.decodeFslData(ob.optJSONObject("user"));
        userInfo.setCity(ob.optString("city", ""));
        this.httpMsg.despatch(userInfo, null, null, this.type, this.pageIndex, 0);
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }

    private void returnMobileBallSendSuccess(JSONObject ob) {
        UserInfo userInfo = new UserInfo();
        userInfo.decodeFslData(ob.optJSONObject("user"));
        userInfo.setCity(ob.optString("city", ""));
        this.httpMsg.despatch(userInfo, ob.optInt("bean", 0), ob.optInt("diamond", 0), this.type, this.pageIndex, 0);
    }

    private void returnHydrangeaHistory(JSONObject ob) {
        String result = ob.optString("result");
        ArrayList<MobileBallRecord> records = new ArrayList<MobileBallRecord>();
        if (MyTool.stringValid(result)) {
            try {
                JSONArray arr = new JSONArray(result);
                int size = arr.length();
                int i = 0;
                while (i < size) {
                    MobileBallRecord record = new MobileBallRecord();
                    record.decodeBallRecord(arr.optJSONObject(i));
                    records.add(record);
                    ++i;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.httpMsg.despatch(records, null, null, this.type, this.pageIndex, 0);
    }

    private void returnHydrangeaList(JSONObject ob) throws Exception {
        String result = ob.optString("result");
        ArrayList<HydrangeaListInfo> hydrangeaListInfos = new ArrayList<HydrangeaListInfo>();
        HydrangeaFreeInfo freeInfo = new HydrangeaFreeInfo();
        freeInfo.decodeFreeInfo(ob);
        if (MyTool.stringValid(result)) {
            JSONArray arr = new JSONArray(result);
            int size = arr.length();
            if (size == 0) {
                return;
            }
            int i = 0;
            while (i < size) {
                JSONObject obj = arr.getJSONObject(i);
                HydrangeaListInfo hydrangeaListInfo = new HydrangeaListInfo();
                hydrangeaListInfo.setName(obj.optString("name"));
                hydrangeaListInfo.setIcon(obj.optString("icon"));
                hydrangeaListInfo.setMobileGlamour(obj.optInt("mobileGlamour"));
                hydrangeaListInfo.setMobileMarry(obj.optInt("mobileMarry"));
                hydrangeaListInfo.setDetail(obj.optString("detail"));
                hydrangeaListInfo.setMobilePoint(obj.optInt("mobilePoint"));
                hydrangeaListInfo.setPrice(obj.optInt("price"));
                hydrangeaListInfo.setGiftCode(obj.optInt("giftCode"));
                hydrangeaListInfo.setVipLevel(obj.optInt("vipLevel"));
                hydrangeaListInfo.setDiscount(obj.optInt("discount", 1));
                hydrangeaListInfo.setPriceUnit(obj.optInt("priceUnit"));
                hydrangeaListInfo.setIsBroadcast(obj.optInt("isBroadcast"));
                hydrangeaListInfo.setMobileCoin(obj.optInt("mobileCoin"));
                hydrangeaListInfos.add(hydrangeaListInfo);
                ++i;
            }
        }
        this.httpMsg.despatch(hydrangeaListInfos, freeInfo, ob.optInt("giftFreeNext", 0), this.type, ob.optInt("diamond", 0), ob.optInt("bean", 0));
    }
}

