/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.Leaderboard;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class LeaderboardRequest
extends BaseRequstClass
implements IHttpUrl,
IHttpListener {
    private String TAG = "LeaderboardRequest";
    private int type;
    private HttpConnect conn;
    private HttpMsg mHttpMsg;

    public LeaderboardRequest(Context context, HttpMsg httpMsg, String url) {
        this.mHttpMsg = httpMsg;
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestActions(int action, Map<String, Object> map) {
        this.type = action;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (val == null) continue;
                obj.put(key, val);
            }
            Log.v((String)this.TAG, (String)obj.toString());
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void decode(InputStream in) throws IOException {
        String tmp = Tools.seekSep((InputStream)in);
        Log.v((String)this.TAG, (String)tmp);
        try {
            JSONObject object = new JSONObject(tmp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 10001: {
                        this.returnLeaderboardData(object);
                    }
                }
            } else {
                int result = object.optInt("result");
                String msg = object.optString("msg");
                if (msg == null || msg.equals("")) {
                    this.mHttpMsg.handleErrorInfo("", result, this.type);
                } else {
                    this.errInfo(this.mHttpMsg, this.type, result, msg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errInfo(this.mHttpMsg, this.type, 0, "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
        }
    }

    private void returnLeaderboardData(JSONObject ob) {
        ArrayList<Leaderboard> list = new ArrayList<Leaderboard>();
        try {
            String listString = ob.optString("top", "");
            if (!LeaderboardRequest.isBlank(listString)) {
                JSONArray jsonArray = ob.getJSONArray("top");
                int i = 0;
                while (i < jsonArray.length()) {
                    Leaderboard leaderboard = new Leaderboard();
                    leaderboard.resolveData(jsonArray.getJSONObject(i));
                    list.add(leaderboard);
                    ++i;
                }
                this.mHttpMsg.despatch(list, null, null, this.type, 0, 0);
            } else {
                this.mHttpMsg.despatch(list, null, null, this.type, 0, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }
}

