/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.ManitoData;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ManitoRequest
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private String TAG = "ManitoRequest";
    private HttpMsg mHttpMsg;
    private HttpConnect conn;
    private int type;
    private int pageIndex;
    private boolean isFreeSys;

    public ManitoRequest(Context context, HttpMsg httpMsg, int type) {
        String url = "http://mob2.imlianai.com/call.do?cmd=";
        switch (type) {
            case 2001: {
                url = "http://mob2.imlianai.com/call.do?cmd=god.getGodList";
                break;
            }
            case 2002: {
                url = "http://mob2.imlianai.com/call.do?cmd=god.getCardList";
                break;
            }
            case 2003: {
                url = "http://mob2.imlianai.com/call.do?cmd=god.getRewardUser";
                break;
            }
            case 2004: {
                url = "http://mob2.imlianai.com/call.do?cmd=god.getPublishGodList";
                break;
            }
            case 2005: {
                url = "http://mob2.imlianai.com/call.do?cmd=god.publishGod";
                break;
            }
            case 2006: {
                url = "http://mob2.imlianai.com/call.do?cmd=god.takeReward";
                break;
            }
        }
        this.mHttpMsg = httpMsg;
        this.type = type;
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void requestMain(String uid, int pageIndex) {
        this.pageIndex = pageIndex;
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("pageIndex", pageIndex);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestCard(String uid, boolean isFreeSys) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            this.isFreeSys = isFreeSys;
            if (isFreeSys) {
                object.put("type", 0);
            } else {
                object.put("type", 1);
            }
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestVisitList(int id, int pageIndex, String lid) {
        byte[] data = null;
        try {
            this.pageIndex = pageIndex;
            JSONObject object = new JSONObject();
            object.put("id", id);
            object.put("pageIndex", pageIndex);
            object.put("lid", (Object)lid);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestType(String uid) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestPublish(String uid, int godCode, String loginKey, int index) {
        byte[] data = null;
        try {
            this.pageIndex = index;
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("godCode", godCode);
            object.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void requestVisit(String uid, int type, int id) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("type", type);
            object.put("id", id);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.mHttpMsg.handleErrorInfo(err, -1, this.type);
    }

    public void decode(InputStream in) throws IOException {
        String temp = Tools.seekSep((InputStream)in);
        Log.v((String)this.TAG, (String)temp);
        try {
            ManitoData data = new ManitoData();
            JSONObject object = new JSONObject(temp);
            boolean state = object.optBoolean("state");
            if (state) {
                switch (this.type) {
                    case 2001: {
                        this.decodeMain(object);
                        break;
                    }
                    case 2002: {
                        this.mHttpMsg.despatch(data.decodeCard(object), this.isFreeSys, null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 2003: {
                        this.mHttpMsg.despatch(data.decodeVisitList(object), object.optInt("receiveNum"), null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 2004: {
                        this.mHttpMsg.despatch(data.decodeTypeList(object), object.optInt("diamond"), null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 2005: {
                        this.mHttpMsg.despatch(object.optString("result"), object.optInt("diamond"), null, this.type, this.pageIndex, 0);
                        break;
                    }
                    case 2006: {
                        int id = object.optInt("id");
                        String name = object.optString("name");
                        String uid = object.optString("uid");
                        int rewardNum = object.optInt("rewardNum");
                        this.mHttpMsg.despatch(rewardNum, id > 0 ? uid : Integer.valueOf(id), name, this.type, this.pageIndex, 0);
                        break;
                    }
                }
            } else {
                int result = object.optInt("result");
                String msg = object.optString("msg", "");
                this.errInfo(this.mHttpMsg, this.type, result, msg);
            }
        }
        catch (Exception e) {
            this.errInfo(this.mHttpMsg, this.type, 0, "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
        }
    }

    private void decodeMain(JSONObject object) throws Exception {
        JSONObject obj = object.optJSONObject("result");
        ManitoData sysData = null;
        JSONObject ob = obj.optJSONObject("systemGod");
        if (ob != null) {
            sysData = new ManitoData();
            sysData.setIcon(ob.optString("icon"));
            sysData.setResetTime(ob.optInt("resetTime"));
            sysData.setStatus(ob.optInt("status"));
        }
        ArrayList<ManitoData> userGods = new ArrayList<ManitoData>();
        JSONArray array = obj.optJSONArray("userGod");
        if (array != null) {
            JSONObject o = null;
            ManitoData data = null;
            int i = 0;
            while (i < array.length()) {
                data = new ManitoData();
                o = array.optJSONObject(i);
                data.decodeMain(o);
                userGods.add(data);
                ++i;
            }
        }
        this.mHttpMsg.despatch(userGods, sysData, obj.optString("buyTips"), this.type, this.pageIndex, 0);
    }
}

