/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.BillInfo;
import com.cn.anddev.andengine.model.PayInfo;
import com.cn.anddev.andengine.model.UnicomPayInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class RechargeOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    Context context;
    public static final String TAG = "RechargeOperation";
    public HttpConnect conn = null;
    private int type;
    private int position;

    public RechargeOperation(Context context, HttpMsg httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = "";
        if (type == 1901 || type == 1903 || type == 1906 || type == 1917) {
            url = "http://mob2.imlianai.com/call.do?cmd=mobileTrade.chargeList";
        } else if (type == 1904 || type == 1905 || type == 1907 || type == 1908 || type == 1909 || type == 1910 || type == 1919 || type == 1920) {
            url = "http://mob2.imlianai.com/call.do?cmd=mobileTrade.charge";
        } else if (type == 1902 || type == 1911 || type == 1912 || type == 1916) {
            url = "http://mob2.imlianai.com/call.do?cmd=mobileTrade.tradeAccount";
        } else if (type == 1913 || type == 1914 || type == 1915) {
            url = "http://mob2.imlianai.com/call.do?cmd=mobileTrade.chargeEvent";
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void getMMPayInfo(String uid, String loginKey, int type, int position) {
        this.position = position;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("type", type);
            obj.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getWechatByZWX(String uid, String loginKey, int code, String channel) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("loginKey", (Object)loginKey);
            obj.put("code", code);
            obj.put("type", 13);
            obj.put("channel", (Object)channel);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getPayList(String uid, int type) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("type", type);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void payCard(String uid, String loginKey, int code, String cardNumber, String cardPwd, int bossType, String channel) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("type", 3);
            obj.put("uid", (Object)uid);
            obj.put("loginKey", (Object)loginKey);
            obj.put("channel", (Object)channel);
            obj.put("code", code);
            obj.put("cardNumber", (Object)cardNumber);
            obj.put("cardPwd", (Object)cardPwd);
            obj.put("bossType", bossType);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getUnicomBasicinfo(String uid, String loginKey) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("type", 12);
            obj.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getPayUnicomOrder(String uid, int position, int code, String loginKey, String channel, String macaddress, String ipaddress, String imei, String appversion, String channelid) {
        this.position = position;
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("code", code);
            obj.put("loginKey", (Object)loginKey);
            obj.put("channel", (Object)channel);
            obj.put("type", 11);
            obj.put("macaddress", (Object)macaddress);
            obj.put("ipaddress", (Object)ipaddress);
            obj.put("imei", (Object)imei);
            obj.put("appversion", (Object)appversion);
            obj.put("channelid", (Object)channelid);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getAlipayOrder(String loginKey, int code, String uid, String channel) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("loginKey", (Object)loginKey);
            obj.put("code", code);
            obj.put("type", 8);
            obj.put("uid", (Object)uid);
            obj.put("channel", (Object)channel);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getUnionpayOrder(String loginKey, int code, String uid, String channel) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("code", code);
            obj.put("loginKey", (Object)loginKey);
            obj.put("channel", (Object)channel);
            obj.put("type", 14);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getWechatOrder(String loginKey, int code, String uid, String channel) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("code", code);
            obj.put("type", 7);
            obj.put("loginKey", (Object)loginKey);
            obj.put("channel", (Object)channel);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getMyWealth(String loginKey, String uid) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            obj.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getAccountInfo(int type, String uid, String loginKey, int code) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            if (loginKey != null) {
                obj.put("loginKey", (Object)loginKey);
            }
            obj.put("type", type);
            if (code > 0) {
                obj.put("code", code);
            }
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void RechargeEventOperation(String uid, String loginKey, int type) {
        byte[] data = null;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            if (loginKey != null) {
                obj.put("loginKey", (Object)loginKey);
            }
            obj.put("type", type);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getMybill(String uid, String loginKey, int type, int page) {
        byte[] data = null;
        this.position = page;
        try {
            JSONObject obj = new JSONObject();
            obj.put("uid", (Object)uid);
            if (loginKey != null) {
                obj.put("loginKey", (Object)loginKey);
            }
            obj.put("type", type);
            obj.put("pageIndex", page);
            data = DESencryption.getEncString((String)obj.toString()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    private void returnPayListInfo(JSONObject jsonObject, boolean mm) {
        try {
            ArrayList<PayInfo> list = new ArrayList<PayInfo>();
            String result = jsonObject.optString("result", "");
            if (MyTool.stringValid(result)) {
                JSONArray arr = new JSONArray(result);
                int i = 0;
                while (i < arr.length()) {
                    JSONObject obj = arr.getJSONObject(i);
                    PayInfo payInfo = new PayInfo();
                    payInfo.parsingPayinfo(obj, mm);
                    list.add(payInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(list, null, null, this.type, this.position, 0);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnExchangeList(String result) {
        try {
            ArrayList<PayInfo> list = new ArrayList<PayInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray arr = new JSONArray(result);
                int i = 0;
                while (i < arr.length()) {
                    JSONObject obj = arr.getJSONObject(i);
                    PayInfo payInfo = new PayInfo();
                    payInfo.parsingExchangeList(obj);
                    list.add(payInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(list, null, null, this.type, this.position, 0);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnEventList(JSONObject jsonObject) {
        try {
            JSONObject object;
            PayInfo payInfo;
            JSONObject obj;
            int i;
            JSONArray arr;
            ArrayList<PayInfo> firstRechargeInfos = new ArrayList<PayInfo>();
            ArrayList<PayInfo> perdayRechargeInfos = new ArrayList<PayInfo>();
            PayInfo limitRechargeInfo = null;
            String firstReward = jsonObject.optString("firstReward", "");
            String accumulate = jsonObject.optString("accumulate", "");
            String timeLimit = jsonObject.optString("timeLimit", "");
            String firstList = jsonObject.optString("firstList", "");
            if (MyTool.stringValid(accumulate)) {
                arr = new JSONArray(accumulate);
                i = 0;
                while (i < arr.length()) {
                    obj = arr.getJSONObject(i);
                    payInfo = new PayInfo();
                    payInfo.parsingRechargeEvent(obj);
                    perdayRechargeInfos.add(payInfo);
                    ++i;
                }
            }
            if (MyTool.stringValid(timeLimit)) {
                limitRechargeInfo = new PayInfo();
                object = new JSONObject(timeLimit);
                limitRechargeInfo.parsingRechargeEvent(object);
            }
            if (MyTool.stringValid(firstReward)) {
                int n;
                object = new JSONObject(firstReward);
                PayInfo payInfo2 = new PayInfo();
                payInfo2.parsingRechargeEvent(object);
                if (payInfo2.getState() == 0) {
                    n = 2;
                } else {
                    payInfo2.getClass();
                    n = 1;
                }
                payInfo2.setState(n);
                firstRechargeInfos.add(payInfo2);
            } else if (MyTool.stringValid(firstList)) {
                arr = new JSONArray(firstList);
                i = 0;
                while (i < arr.length()) {
                    obj = arr.getJSONObject(i);
                    payInfo = new PayInfo();
                    payInfo.parsingRechargeEvent(obj);
                    payInfo.getClass();
                    payInfo.setState(0);
                    firstRechargeInfos.add(payInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(firstRechargeInfos, perdayRechargeInfos, limitRechargeInfo, this.type, 0, 0);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnBillList(String result) {
        try {
            ArrayList<BillInfo> billInfos = new ArrayList<BillInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray arr = new JSONArray(result);
                int i = 0;
                while (i < arr.length()) {
                    JSONObject obj = arr.getJSONObject(i);
                    BillInfo billInfo = new BillInfo();
                    billInfo.parseingBill(obj);
                    billInfos.add(billInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(billInfos, null, null, this.type, this.position, this.position);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)("\u7c7b\u578b+" + this.type + ":" + temp));
            JSONObject ob = new JSONObject(temp);
            boolean state = ob.getBoolean("state");
            if (state) {
                switch (this.type) {
                    case 1901: {
                        this.returnPayListInfo(ob, false);
                        break;
                    }
                    case 1903: {
                        this.returnPayListInfo(ob, false);
                        break;
                    }
                    case 1904: {
                        this.httpMsg.despatch(ob.optString("result", ""), null, null, this.type, this.position, 1);
                        break;
                    }
                    case 1905: {
                        UnicomPayInfo unicomPayBasicInfo = new UnicomPayInfo();
                        unicomPayBasicInfo.ParseUnicomBasicInfo(ob);
                        this.httpMsg.despatch(unicomPayBasicInfo, null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1906: {
                        this.returnPayListInfo(ob, false);
                        break;
                    }
                    case 1907: {
                        UnicomPayInfo unicomPayOrderInfo = new UnicomPayInfo();
                        unicomPayOrderInfo.ParseUnicomOrderInfo(ob);
                        this.httpMsg.despatch(unicomPayOrderInfo, null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1908: {
                        this.httpMsg.despatch(ob.optString("result", ""), null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1909: {
                        String respCode = ob.optString("respCode", "");
                        if (respCode.equals("00")) {
                            String tn = ob.optString("tn", "");
                            if (!tn.trim().equals("") && !tn.equals("null")) {
                                this.httpMsg.despatch(tn, null, null, this.type, this.position, 0);
                                break;
                            }
                            this.httpMsg.handleErrorInfo("\u8fd4\u56de\u6570\u636e\u9519\u8bef", 0, this.type);
                            break;
                        }
                        String messageg = ob.optString("respMsg", "");
                        this.httpMsg.handleErrorInfo(messageg.equals("") || messageg.equals("null") ? "\u8fd4\u56de\u6570\u636e\u9519\u8bef" : messageg, 0, this.type);
                        break;
                    }
                    case 1910: {
                        this.httpMsg.despatch(ob.optString("result", ""), null, null, this.type, this.position, 0);
                        break;
                    }
                    case 1911: {
                        this.returnExchangeList(ob.optString("result", ""));
                        break;
                    }
                    case 1912: {
                        this.httpMsg.despatch(ob.optString("result", ""), null, null, this.type, 0, 0);
                        break;
                    }
                    case 1902: {
                        this.httpMsg.despatch(null, null, null, this.type, 0, 0);
                        break;
                    }
                    case 1913: {
                        String result = ob.optString("result", "");
                        this.httpMsg.despatch(result, null, null, this.type, 0, 0);
                        break;
                    }
                    case 1914: {
                        this.returnEventList(ob);
                        break;
                    }
                    case 1915: {
                        this.httpMsg.despatch(ob.optString("result", "\u9886\u53d6\u6210\u529f"), null, null, this.type, 0, 0);
                        break;
                    }
                    case 1916: {
                        this.returnBillList(ob.optString("result", ""));
                        break;
                    }
                    case 1917: {
                        this.returnPayListInfo(ob, true);
                        break;
                    }
                    case 1919: {
                        this.httpMsg.despatch(null, null, null, this.type, this.position, this.position);
                        break;
                    }
                    case 1920: {
                        this.httpMsg.despatch(temp, null, null, this.type, this.position, 0);
                        break;
                    }
                    default: {
                        this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u9519\u8bef", 0, this.type);
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                this.userErrInfo(result, ob.optString("msg", ""));
            }
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

