/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.entity;

import android.content.Context;
import android.util.Log;
import com.cn.anddev.andengine.entity.BaseRequstClass;
import com.cn.anddev.andengine.factory.HttpMsg;
import com.cn.anddev.andengine.factory.IHttpUrl;
import com.cn.anddev.andengine.factory.MyTool;
import com.cn.anddev.andengine.http.HttpConnect;
import com.cn.anddev.andengine.http.IHttpListener;
import com.cn.anddev.andengine.model.TitleInfo;
import com.cn.anddev.andengine.tools.DESencryption;
import com.cn.anddev.andengine.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class TitleOperation
extends BaseRequstClass
implements IHttpListener,
IHttpUrl {
    private HttpMsg httpMsg;
    Context context;
    public static final String TAG = "TitleOperation";
    public HttpConnect conn = null;
    private int type;
    private int position;
    private int state;

    public TitleOperation(Context context, HttpMsg httpMsg, int type) {
        this.context = context;
        this.httpMsg = httpMsg;
        this.type = type;
        String url = "";
        switch (type) {
            case 1328: {
                url = "http://mob2.imlianai.com/call.do?cmd=title.getMyTitle";
                break;
            }
            case 1329: {
                url = "http://mob2.imlianai.com/call.do?cmd=title.getOtherTitle";
                break;
            }
            case 1330: {
                url = "http://mob2.imlianai.com/call.do?cmd=title.getTitleCode";
                break;
            }
            case 1331: {
                url = "http://mob2.imlianai.com/call.do?cmd=title.getTitleInfo";
                break;
            }
            case 1332: {
                url = "http://mob2.imlianai.com/call.do?cmd=title.changeStatus";
                break;
            }
            case 1338: {
                url = "http://mob2.imlianai.com/call.do?cmd=title.getUsingTitleInfo";
                break;
            }
            default: {
                url = "";
            }
        }
        this.conn = new HttpConnect(url, (IHttpListener)this, context);
    }

    public void handleError(String err) throws IOException {
        this.httpMsg.handleErrorInfo(err, 0, this.type);
    }

    public void getTitleList(String uid, String loginKey) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            if (loginKey != null) {
                object.put("loginKey", (Object)loginKey);
            }
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getTitleDetailList(String uid, int type, int postion) {
        this.position = postion;
        this.state = type;
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("type", type);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getTitleDetailListOther(String uid, int type, int postion, int titleCode) {
        this.position = postion;
        this.state = type;
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("titleCode", titleCode);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void changeTitleStatus(String uid, int titleCode, int status) {
        byte[] data = null;
        this.state = status;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("status", status);
            object.put("titleCode", titleCode);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    public void getUsingTitle(String uid, String tid, String loginKey) {
        byte[] data = null;
        try {
            JSONObject object = new JSONObject();
            object.put("uid", (Object)uid);
            object.put("tid", (Object)tid);
            object.put("loginKey", (Object)loginKey);
            data = DESencryption.getEncString((String)object.toString()).getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.setPostData(data);
        this.conn.start();
    }

    private void returnTitleList(String result) {
        try {
            ArrayList<TitleInfo> list = new ArrayList<TitleInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    TitleInfo titleInfo = new TitleInfo();
                    titleInfo.parsingTitleList(jsonObject);
                    list.add(titleInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(list, null, null, this.type, 0, 0);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void returnTitleDetailList(String result, int index) {
        try {
            ArrayList<TitleInfo> list = new ArrayList<TitleInfo>();
            if (MyTool.stringValid(result)) {
                JSONArray jsonArray = new JSONArray(result);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    TitleInfo titleInfo = new TitleInfo();
                    titleInfo.parsingTitleDetail(jsonObject);
                    titleInfo.setIndex(index);
                    list.add(titleInfo);
                    ++i;
                }
            }
            this.httpMsg.despatch(list, null, null, this.type, this.state, this.position);
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    public void decode(InputStream in) throws IOException {
        try {
            String temp = Tools.seekSep((InputStream)in);
            Log.v((String)TAG, (String)temp);
            JSONObject ob = new JSONObject(temp);
            boolean mstate = ob.getBoolean("state");
            if (mstate) {
                switch (this.type) {
                    case 1328: {
                        this.returnTitleList(ob.optString("result", ""));
                        break;
                    }
                    case 1329: {
                        this.returnTitleList(ob.optString("result", ""));
                        break;
                    }
                    case 1330: {
                        this.returnTitleDetailList(ob.optString("result", ""), ob.optInt("index", 0));
                        break;
                    }
                    case 1331: {
                        this.returnTitleDetailList(ob.optString("result", ""), 0);
                        break;
                    }
                    case 1332: {
                        this.httpMsg.despatch(null, null, null, this.type, this.state, this.position);
                        break;
                    }
                    case 1338: {
                        String result = ob.optString("result", "");
                        JSONObject jsonObject = new JSONObject(result);
                        TitleInfo titleInfo = new TitleInfo();
                        titleInfo.parsingTitleDetail(jsonObject);
                        this.httpMsg.despatch(titleInfo, null, null, this.type, 0, 0);
                        break;
                    }
                }
            } else {
                int result = ob.optInt("result");
                this.userErrInfo(result, ob.optString("msg", ""));
            }
        }
        catch (Exception e) {
            this.httpMsg.handleErrorInfo("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", 0, this.type);
        }
    }

    private void userErrInfo(int result, String msg) {
        if (msg != null && !msg.equals("") && !msg.equals("null")) {
            this.httpMsg.handleErrorInfo(msg, result, this.type);
            return;
        }
        this.httpMsg.handleErrorInfo(this.returnErrInfo(result), result, this.type);
    }
}

