/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.model;

import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONObject;

public class RedPocket
implements Serializable {
    private int code;
    private String imgUrl;
    private String name;
    private int price;
    private String title;
    private String normalImg;
    private String pressedImg;
    private boolean isCheck;

    public boolean isCheck() {
        return this.isCheck;
    }

    public void setCheck(boolean isCheck) {
        this.isCheck = isCheck;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNormalImg() {
        return this.normalImg;
    }

    public void setNormalImg(String normalImg) {
        this.normalImg = normalImg;
    }

    public String getPressedImg() {
        return this.pressedImg;
    }

    public void setPressedImg(String pressImg) {
        this.pressedImg = pressImg;
    }

    public void decodeRedPocket(JSONObject obj) {
        try {
            this.code = obj.optInt("code", -1);
            this.imgUrl = obj.optString("imgUrl", "");
            this.name = obj.optString("name", "");
            this.price = obj.optInt("price", 0);
            this.title = obj.optString("title", "");
            String images = obj.optString("images");
            if (images != null && images.length() > 0) {
                JSONArray array = new JSONArray(images);
                int i = 0;
                while (i < array.length()) {
                    TempImage image = new TempImage();
                    image.decodeImage(array.optJSONObject(i));
                    if (image.scale.equals("2x") && image.state.equals("normal")) {
                        this.normalImg = image.filename;
                    }
                    if (image.scale.equals("2x") && image.state.equals("pressed")) {
                        this.pressedImg = image.filename;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class TempImage {
        String filename;
        String idiom;
        String scale;
        String state;

        TempImage() {
        }

        private void decodeImage(JSONObject ob) {
            this.filename = ob.optString("filename", "");
            this.idiom = ob.optString("idiom", "");
            this.scale = ob.optString("scale", "");
            this.state = ob.optString("state", "");
        }
    }
}

