/*
 * Decompiled with CFR 0.152.
 */
package com.cn.anddev.andengine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TreeListAndHistoryModel
implements Serializable,
Comparable<TreeListAndHistoryModel> {
    private static final long serialVersionUID = -7534001337461171534L;
    private String info;
    private String date;
    private String nameA;
    private int idA;
    private String nameB;
    private int idB;
    private String imageUrlA;
    private String imageUrlB;
    private int level;
    private int index;
    private int growth;
    private int health;
    private int fruitNowNum;
    private boolean isTwoPeople = false;
    private boolean isHistory = false;

    public boolean getIsHistory() {
        return this.isHistory;
    }

    public String getDate() {
        return this.date;
    }

    public int getFruitNowNum() {
        return this.fruitNowNum;
    }

    public boolean getIsTwoPeople() {
        return this.isTwoPeople;
    }

    public int getGrowth() {
        return this.growth;
    }

    public int getHealth() {
        return this.health;
    }

    public int getIdA() {
        return this.idA;
    }

    public int getIdB() {
        return this.idB;
    }

    public String getImageUrlA() {
        return this.imageUrlA;
    }

    public String getImageUrlB() {
        return this.imageUrlB;
    }

    public int getIndex() {
        return this.index;
    }

    public String getInfo() {
        return this.info;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameA() {
        return this.nameA;
    }

    public String getNameB() {
        return this.nameB;
    }

    public List<TreeListAndHistoryModel> analyse(JSONObject obj) {
        ArrayList<TreeListAndHistoryModel> models;
        block8: {
            models = new ArrayList<TreeListAndHistoryModel>();
            if (obj != null) break block8;
            return null;
        }
        try {
            JSONArray items = obj.optJSONArray("result");
            int i = 0;
            while (i < items.length()) {
                JSONObject tempJson = items.getJSONObject(i);
                TreeListAndHistoryModel model = new TreeListAndHistoryModel();
                model.info = tempJson.optString("text");
                model.date = tempJson.optString("time");
                if (tempJson.has("text")) {
                    model.nameA = tempJson.optString("name");
                    model.imageUrlA = tempJson.optString("head");
                    model.idA = tempJson.optInt("uid");
                    model.isHistory = true;
                    models.add(model);
                } else {
                    model.index = tempJson.optInt("id");
                    model.idA = tempJson.optInt("hid");
                    model.nameA = tempJson.optString("hName");
                    model.imageUrlA = tempJson.optString("hHead");
                    model.idB = tempJson.optInt("wid");
                    if (model.idB != 0) {
                        model.isTwoPeople = true;
                    }
                    model.nameB = tempJson.optString("wName");
                    model.imageUrlB = tempJson.optString("wHead");
                    model.level = tempJson.optInt("level");
                    model.growth = tempJson.optInt("growth");
                    model.health = tempJson.optInt("health");
                    model.fruitNowNum = tempJson.optInt("fruitNowNum");
                    models.add(model);
                }
                ++i;
            }
            if (this.isHistory) {
                Collections.sort(models);
            }
            return models;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int compareTo(TreeListAndHistoryModel arg0) {
        if (this.isHistory) {
            return arg0.getDate().compareTo(this.date);
        }
        return this.index - arg0.getIndex();
    }
}

